/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf;

import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;

public final class RbfResult
implements Persistable {
    private RbfRequestId requestId = null;
    private int statusCode = 0;
    private Object details = null;
    public static final int RESULT_OK = 0;
    public static final int RESULT_BUSY = 2;
    public static final int RESULT_INVALID_REQUEST = 4;
    public static final int RESULT_INTERNAL_ERROR = 8;
    public static final int RESULT_APPLICATION_ERROR = 12;
    public static final int RESULT_HANDLER_UNAVAILABLE = 16;
    public static final int RESULT_HANDLER_NOT_CAPABLE = 20;
    public static final int RESULT_HANDLER_INVALID_REQUEST = 24;
    public static final int RESULT_HANDLER_FAILURE = 28;
    public static final int RESULT_HANDLER_OUTAGE = 32;
    public static final int RESULT_CANCELED_AT_SUBMITTER = 36;
    public static final int RESULT_CANCELED_DO_NOT_HANDLE = 40;
    public static final int RESULT_CANCELED_AT_HANDLER = 44;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$persist$Persistable;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$persist$PersistentData;

    public RbfResult(RbfRequest request) {
        this(request, 0, null);
    }

    public RbfResult(RbfRequest request, int statusCode, Object details) {
        if (request == null) {
            throw new IllegalArgumentException("Null request specified");
        }
        if (!this.isValidStatus(statusCode)) {
            throw new IllegalArgumentException("Invalid status code");
        }
        if (!(details == null || (class$java$io$Serializable == null ? (class$java$io$Serializable = RbfResult.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(details.getClass()) || (class$com$ibm$hwmca$fw$persist$Persistable == null ? (class$com$ibm$hwmca$fw$persist$Persistable = RbfResult.class$("com.ibm.hwmca.fw.persist.Persistable")) : class$com$ibm$hwmca$fw$persist$Persistable).isAssignableFrom(details.getClass()) || (class$com$ibm$hwmca$fw$persist$PersistentData == null ? (class$com$ibm$hwmca$fw$persist$PersistentData = RbfResult.class$("com.ibm.hwmca.fw.persist.PersistentData")) : class$com$ibm$hwmca$fw$persist$PersistentData).isAssignableFrom(details.getClass()))) {
            String msg = "The details object does not implement either java.io.Serializable, com.ibm.hwmca.fw.persist.Persistable, or com.ibm.hwmca.fw.persist.PersistentData";
            throw new IllegalArgumentException(msg);
        }
        this.requestId = request.getIdentifier();
        this.statusCode = statusCode;
        this.details = details;
    }

    public RbfResult(PersistentData data) throws PersistenceException {
        PersistenceManager pm = PersistenceManager.getPersistenceManager();
        Persistent persistent = (Persistent)data;
        int rbfVersion = persistent.rbfVersion;
        RbfRequestId requestId = persistent.requestId;
        this.statusCode = persistent.statusCode;
        this.details = persistent.details == null ? null : pm.containedFormToObject(persistent.details);
    }

    public PersistentData getPersistentData() {
        PersistenceManager pm = PersistenceManager.getPersistenceManager();
        Persistent persistent = new Persistent();
        persistent.rbfVersion = 2;
        persistent.requestId = this.requestId;
        persistent.statusCode = this.statusCode;
        persistent.details = this.details == null ? null : pm.objectToContainedForm(this.details);
        return persistent;
    }

    public boolean isUpgradeData() {
        return false;
    }

    public RbfRequestId getRequestId() {
        return this.requestId;
    }

    public void setStatusCode(int value) {
        if (!this.isValidStatus(value)) {
            throw new IllegalArgumentException("Invalid status code");
        }
        this.statusCode = value;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    private boolean isValidStatus(int status) {
        switch (status) {
            case 0: {
                return true;
            }
            case 2: {
                return true;
            }
            case 4: {
                return true;
            }
            case 8: {
                return true;
            }
            case 12: {
                return true;
            }
            case 16: {
                return true;
            }
            case 20: {
                return true;
            }
            case 24: {
                return true;
            }
            case 28: {
                return true;
            }
            case 32: {
                return true;
            }
            case 36: {
                return true;
            }
            case 40: {
                return true;
            }
            case 44: {
                return true;
            }
        }
        return false;
    }

    public void setDetails(Object details) {
        if (!(details == null || (class$java$io$Serializable == null ? (class$java$io$Serializable = RbfResult.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(details.getClass()) || (class$com$ibm$hwmca$fw$persist$Persistable == null ? (class$com$ibm$hwmca$fw$persist$Persistable = RbfResult.class$("com.ibm.hwmca.fw.persist.Persistable")) : class$com$ibm$hwmca$fw$persist$Persistable).isAssignableFrom(details.getClass()) || (class$com$ibm$hwmca$fw$persist$PersistentData == null ? (class$com$ibm$hwmca$fw$persist$PersistentData = RbfResult.class$("com.ibm.hwmca.fw.persist.PersistentData")) : class$com$ibm$hwmca$fw$persist$PersistentData).isAssignableFrom(details.getClass()))) {
            String msg = "The details object does not implement either java.io.Serializable, com.ibm.hwmca.fw.persist.Persistable, or com.ibm.hwmca.fw.persist.PersistentData";
            throw new IllegalArgumentException(msg);
        }
        this.details = details;
    }

    public Object getDetails() {
        return this.details;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RbfResult)) {
            return false;
        }
        RbfResult result = (RbfResult)obj;
        return this.requestId.equals(result.requestId);
    }

    public int hashCode() {
        return this.requestId.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[RbfResult:\n");
        sb.append("reqId=" + this.requestId + "\n");
        sb.append("status=" + this.statusCode + "\n");
        if (this.details == null) {
            sb.append("details=null]");
        } else {
            sb.append("details=" + this.details.getClass().getName() + "]");
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Persistent
    implements PersistentData {
        private static final long serialVersionUID = -4268460673787736921L;
        int rbfVersion;
        RbfRequestId requestId;
        int statusCode;
        Object details;

        private Persistent() {
        }
    }
}

